# debci-scheduler

`debci-scheduler` is a utility that monitors an APT repository for changes to
certain packages and enqueues `debci` test jobs when changes are detected.

To activate scheduling, an administrator creates a
`/etc/debci/scheduler.conf` file as described in
[Configuration file](#configuration-file) below. It contains general
configuration directives and a list of packages. This list of packages is
called the **Wanted** list.


## Triggers

Simply put: we want a package to be tested if the package or any of its
dependencies has changed.

For any source package listed in **Wanted** list, `debci-scheduler` will
compare its last-seen version with the current version in an APT archive. If
the last-seen version is older or missing, then this is interpreted as the
package having been updated, and a test trigger is recorded with the package
itself as the cause.

The same check is performed for all packages listed as dependencies of the
*binaries* of **Wanted** packages. If any dependency changed, then a trigger
is recorded, with the first detected change recorded as the cause[^1].

Additionally, it is possible to track arbitrary other packages are potential
triggers. This is useful when a package is indirectly affected by another
package.


## Scheduling

`debci` jobs are scheduled for all packages of the **Wanted** list for which a
trigger was recorded.

Additionally, jobs are scheduled for all reverse dependencies of all *binary*
packages of a triggered **Wanted** package.

If any reverse dependency is itself a package in the **Wanted** list, then in
turn, jobs for *its* reverse dependencies are also scheduled. This cascade
continues until only non-Wanted reverse dependencies are left.

For the sake of efficiency, the scheduling described above is skipped for jobs for which a test has already been scheduled with the same parameters (albeit with another trigger).


## Configuration file

`debci-scheduler` is configured by the file `/etc/debci/scheduler.conf`, which
is (roughly)[^2] in the
[deb822](https://manpages.debian.org/unstable/dpkg-dev/deb822.5.en.html)
format.

The file consists of a single control stanza, and an arbitrary list of schedule
stanzas. Stanzas are blocks of headers, are seperated by newlines. Lines
beginning with \# are ignored.

### Control stanza

Control stanzas configure the scheduler in general.

```
Architectures: amd64 arm64
Distributions: stable testing unstable
Addon-Distributions: experimental>unstable stable-backports>stable
```

* **Architectures** (required): List of architectures for which to schedule
  tests. Space-separated.

* **Distributions** (required): List of distributions for which to check for
  updates. Space-separated.

* **Addon-Distributions** (optional): List of add-on distributions for which to
  check for updates. Each addon distribution needs a base distribution.
  Space-separated list of `addon>base` pairs.

### Schedule stanza

Schedule stanzas configure the scheduling of **Wanted** packages.

```
Source: foo
Limit-To-Binaries: libfoo1 libfoo1-tests
Also-Trigger-On: linux-signed-amd64 barbaz
Skip-Trigger-On: mathjax sphinx-rtd-theme
```

* **Source** (required): Name of the source package.

* **Limit-To-Binaries** (optional): Instead of checking the dependencies of all
  binaries built by `Source` for changes, check only the binaries listed here.
  Typically used when there are dedicated `-tests` packages.

* **Also-Trigger-On** (optional): List of names of non-related source packages
  for which a change is also to be considered as a trigger. A typical example
  would be `linux-image-amd64`, and nothing really directly depends on it, but
  a program depending on a particular driver might be affected by it.

* **Skip-Trigger-On** (optional): List of name of related source packages which
  to ignore as triggers. Typical candidates are depedencies of `-doc`
  packages.
  
### Full example

```
Architectures: amd64
Distributions: testing unstable
Addon-Distributions: experimental>unstable

Source: libfoo

# Builds many binaries, but we're only interested in changes that affect the
# -test package
Source: libbar
Limit-To-Binaries: libbar1-tests

# Kernel driver 'bazdriver' affects this test
Source: libbaz
Also-Trigger-On: linux-signed-amd64
```


## Internals

`debci-scheduler` piggy-backs on `debci`'s SQLite3 database in
`/var/lib/debci/data/debci.sqlite3` to track its last-seen versions in a table
called `versions`.

Internally, `debci-scheduler` creates one APT cache per distribution, rather
than one APT cache for all. This is bit less efficient, but greatly simplifies
dependency resolution.


## Limitations

`debci-scheduler` interacts with `debci` through the CLI, so it must be run on
the same host as `debci`. This was slightly less complicated to implement than
going through `debci`s API.


## Footnotes

[^1]: This can be confusing when more than one dependency changed at a time.

[^2]: "Roughly" because the parser has been implemented with the absolute minimal
      effort, and will thus not be able to detect many non-compliant errors.
